package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class NetworkListSubscriptionArgs private(
  networkLists: Output[scala.collection.immutable.List[String]],
  recipients: Output[scala.collection.immutable.List[String]]
) derives ArgsEncoder

object NetworkListSubscriptionArgs:
  def apply(
    networkLists: Input[List[Input[String]]],
    recipients: Input[List[Input[String]]]
  )(using Context): NetworkListSubscriptionArgs =
    new NetworkListSubscriptionArgs(
      networkLists = networkLists.asOutput(isSecret = false),
      recipients = recipients.asOutput(isSecret = false)
    )
