package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Property private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  contractId: Output[String],
  groupId: Output[String],
  hostnames: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyHostname]]],
  latestVersion: Output[Int],
  name: Output[String],
  productId: Output[String],
  productionVersion: Output[Int],
  readVersion: Output[Int],
  ruleErrors: Output[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyRuleError]],
  ruleFormat: Output[String],
  rules: Output[String],
  stagingVersion: Output[Int]
) extends CustomResource derives ResourceDecoder

object Property:
  given outputOps: {} with
    extension(output: Output[Property])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def hostnames: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyHostname]]] = output.flatMap(_.hostnames)
      def latestVersion: Output[Int] = output.flatMap(_.latestVersion)
      def name: Output[String] = output.flatMap(_.name)
      def productId: Output[String] = output.flatMap(_.productId)
      def productionVersion: Output[Int] = output.flatMap(_.productionVersion)
      def readVersion: Output[Int] = output.flatMap(_.readVersion)
      def ruleErrors: Output[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyRuleError]] = output.flatMap(_.ruleErrors)
      def ruleFormat: Output[String] = output.flatMap(_.ruleFormat)
      def rules: Output[String] = output.flatMap(_.rules)
      def stagingVersion: Output[Int] = output.flatMap(_.stagingVersion)

def property(using ctx: Context)(
  name: NonEmptyString,
  args: PropertyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Property] = 
  ctx.registerResource[Property, PropertyArgs]("akamai:index/property:Property", name, args, opts)

