package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class PropertyActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  activationId: Output[String],
  autoAcknowledgeRuleWarnings: Output[Option[Boolean]],
  complianceRecord: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecord]],
  contacts: Output[scala.collection.immutable.List[String]],
  errors: Output[String],
  network: Output[Option[String]],
  note: Output[Option[String]],
  propertyId: Output[String],
  ruleErrors: Output[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyActivationRuleError]],
  status: Output[String],
  version: Output[Int],
  warnings: Output[String]
) extends CustomResource derives ResourceDecoder

object PropertyActivation:
  given outputOps: {} with
    extension(output: Output[PropertyActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def activationId: Output[String] = output.flatMap(_.activationId)
      def autoAcknowledgeRuleWarnings: Output[Option[Boolean]] = output.flatMap(_.autoAcknowledgeRuleWarnings)
      def complianceRecord: Output[Option[besom.api.akamai.outputs.PropertyActivationComplianceRecord]] = output.flatMap(_.complianceRecord)
      def contacts: Output[scala.collection.immutable.List[String]] = output.flatMap(_.contacts)
      def errors: Output[String] = output.flatMap(_.errors)
      def network: Output[Option[String]] = output.flatMap(_.network)
      def note: Output[Option[String]] = output.flatMap(_.note)
      def propertyId: Output[String] = output.flatMap(_.propertyId)
      def ruleErrors: Output[scala.collection.immutable.List[besom.api.akamai.outputs.PropertyActivationRuleError]] = output.flatMap(_.ruleErrors)
      def status: Output[String] = output.flatMap(_.status)
      def version: Output[Int] = output.flatMap(_.version)
      def warnings: Output[String] = output.flatMap(_.warnings)

def propertyActivation(using ctx: Context)(
  name: NonEmptyString,
  args: PropertyActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[PropertyActivation] = 
  ctx.registerResource[PropertyActivation, PropertyActivationArgs]("akamai:index/propertyActivation:PropertyActivation", name, args, opts)

