package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PropertyActivationArgs private(
  activationId: Output[Option[String]],
  autoAcknowledgeRuleWarnings: Output[Option[Boolean]],
  complianceRecord: Output[Option[besom.api.akamai.inputs.PropertyActivationComplianceRecordArgs]],
  contacts: Output[scala.collection.immutable.List[String]],
  network: Output[Option[String]],
  note: Output[Option[String]],
  propertyId: Output[String],
  ruleErrors: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.PropertyActivationRuleErrorArgs]]],
  version: Output[Int]
) derives ArgsEncoder

object PropertyActivationArgs:
  def apply(
    activationId: Input.Optional[String] = None,
    autoAcknowledgeRuleWarnings: Input.Optional[Boolean] = None,
    complianceRecord: Input.Optional[besom.api.akamai.inputs.PropertyActivationComplianceRecordArgs] = None,
    contacts: Input[List[Input[String]]],
    network: Input.Optional[String] = None,
    note: Input.Optional[String] = None,
    propertyId: Input[String],
    ruleErrors: Input.Optional[List[Input[besom.api.akamai.inputs.PropertyActivationRuleErrorArgs]]] = None,
    version: Input[Int]
  )(using Context): PropertyActivationArgs =
    new PropertyActivationArgs(
      activationId = activationId.asOptionOutput(isSecret = false),
      autoAcknowledgeRuleWarnings = autoAcknowledgeRuleWarnings.asOptionOutput(isSecret = false),
      complianceRecord = complianceRecord.asOptionOutput(isSecret = false),
      contacts = contacts.asOutput(isSecret = false),
      network = network.asOptionOutput(isSecret = false),
      note = note.asOptionOutput(isSecret = false),
      propertyId = propertyId.asOutput(isSecret = false),
      ruleErrors = ruleErrors.asOptionOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
