package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PropertyArgs private(
  contractId: Output[String],
  groupId: Output[String],
  hostnames: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.PropertyHostnameArgs]]],
  name: Output[Option[String]],
  productId: Output[String],
  ruleFormat: Output[Option[String]],
  rules: Output[Option[String]]
) derives ArgsEncoder

object PropertyArgs:
  def apply(
    contractId: Input[String],
    groupId: Input[String],
    hostnames: Input.Optional[List[Input[besom.api.akamai.inputs.PropertyHostnameArgs]]] = None,
    name: Input.Optional[String] = None,
    productId: Input[String],
    ruleFormat: Input.Optional[String] = None,
    rules: Input.Optional[String] = None
  )(using Context): PropertyArgs =
    new PropertyArgs(
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      hostnames = hostnames.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      productId = productId.asOutput(isSecret = false),
      ruleFormat = ruleFormat.asOptionOutput(isSecret = false),
      rules = rules.asOptionOutput(isSecret = false)
    )
