package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class PropertyInclude private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  contractId: Output[String],
  groupId: Output[String],
  latestVersion: Output[Int],
  name: Output[String],
  productId: Output[Option[String]],
  productionVersion: Output[String],
  ruleErrors: Output[String],
  ruleFormat: Output[String],
  ruleWarnings: Output[String],
  rules: Output[String],
  stagingVersion: Output[String],
  `type`: Output[String]
) extends CustomResource derives ResourceDecoder

object PropertyInclude:
  given outputOps: {} with
    extension(output: Output[PropertyInclude])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def latestVersion: Output[Int] = output.flatMap(_.latestVersion)
      def name: Output[String] = output.flatMap(_.name)
      def productId: Output[Option[String]] = output.flatMap(_.productId)
      def productionVersion: Output[String] = output.flatMap(_.productionVersion)
      def ruleErrors: Output[String] = output.flatMap(_.ruleErrors)
      def ruleFormat: Output[String] = output.flatMap(_.ruleFormat)
      def ruleWarnings: Output[String] = output.flatMap(_.ruleWarnings)
      def rules: Output[String] = output.flatMap(_.rules)
      def stagingVersion: Output[String] = output.flatMap(_.stagingVersion)
      def `type`: Output[String] = output.flatMap(_.`type`)

def propertyInclude(using ctx: Context)(
  name: NonEmptyString,
  args: PropertyIncludeArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[PropertyInclude] = 
  ctx.registerResource[PropertyInclude, PropertyIncludeArgs]("akamai:index/propertyInclude:PropertyInclude", name, args, opts)

