package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class PropertyIncludeActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  autoAcknowledgeRuleWarnings: Output[Option[Boolean]],
  complianceRecord: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecord]],
  contractId: Output[String],
  groupId: Output[String],
  includeId: Output[String],
  network: Output[String],
  note: Output[Option[String]],
  notifyEmails: Output[scala.collection.immutable.List[String]],
  validations: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object PropertyIncludeActivation:
  given outputOps: {} with
    extension(output: Output[PropertyIncludeActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def autoAcknowledgeRuleWarnings: Output[Option[Boolean]] = output.flatMap(_.autoAcknowledgeRuleWarnings)
      def complianceRecord: Output[Option[besom.api.akamai.outputs.PropertyIncludeActivationComplianceRecord]] = output.flatMap(_.complianceRecord)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def includeId: Output[String] = output.flatMap(_.includeId)
      def network: Output[String] = output.flatMap(_.network)
      def note: Output[Option[String]] = output.flatMap(_.note)
      def notifyEmails: Output[scala.collection.immutable.List[String]] = output.flatMap(_.notifyEmails)
      def validations: Output[String] = output.flatMap(_.validations)
      def version: Output[Int] = output.flatMap(_.version)

def propertyIncludeActivation(using ctx: Context)(
  name: NonEmptyString,
  args: PropertyIncludeActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[PropertyIncludeActivation] = 
  ctx.registerResource[PropertyIncludeActivation, PropertyIncludeActivationArgs]("akamai:index/propertyIncludeActivation:PropertyIncludeActivation", name, args, opts)

