package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PropertyIncludeActivationArgs private(
  autoAcknowledgeRuleWarnings: Output[Option[Boolean]],
  complianceRecord: Output[Option[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordArgs]],
  contractId: Output[String],
  groupId: Output[String],
  includeId: Output[String],
  network: Output[String],
  note: Output[Option[String]],
  notifyEmails: Output[scala.collection.immutable.List[String]],
  version: Output[Int]
) derives ArgsEncoder

object PropertyIncludeActivationArgs:
  def apply(
    autoAcknowledgeRuleWarnings: Input.Optional[Boolean] = None,
    complianceRecord: Input.Optional[besom.api.akamai.inputs.PropertyIncludeActivationComplianceRecordArgs] = None,
    contractId: Input[String],
    groupId: Input[String],
    includeId: Input[String],
    network: Input[String],
    note: Input.Optional[String] = None,
    notifyEmails: Input[List[Input[String]]],
    version: Input[Int]
  )(using Context): PropertyIncludeActivationArgs =
    new PropertyIncludeActivationArgs(
      autoAcknowledgeRuleWarnings = autoAcknowledgeRuleWarnings.asOptionOutput(isSecret = false),
      complianceRecord = complianceRecord.asOptionOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      includeId = includeId.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false),
      note = note.asOptionOutput(isSecret = false),
      notifyEmails = notifyEmails.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
