package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PropertyIncludeArgs private(
  contractId: Output[String],
  groupId: Output[String],
  name: Output[Option[String]],
  productId: Output[Option[String]],
  ruleFormat: Output[String],
  rules: Output[Option[String]],
  `type`: Output[String]
) derives ArgsEncoder

object PropertyIncludeArgs:
  def apply(
    contractId: Input[String],
    groupId: Input[String],
    name: Input.Optional[String] = None,
    productId: Input.Optional[String] = None,
    ruleFormat: Input[String],
    rules: Input.Optional[String] = None,
    `type`: Input[String]
  )(using Context): PropertyIncludeArgs =
    new PropertyIncludeArgs(
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      productId = productId.asOptionOutput(isSecret = false),
      ruleFormat = ruleFormat.asOutput(isSecret = false),
      rules = rules.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
