package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ProviderArgsEncoder

final case class ProviderArgs private(
  cacheEnabled: Output[Option[Boolean]],
  config: Output[Option[besom.api.akamai.inputs.ProviderConfigArgs]],
  configSection: Output[Option[String]],
  edgerc: Output[Option[String]],
  requestLimit: Output[Option[Int]]
) derives ProviderArgsEncoder

object ProviderArgs:
  def apply(
    cacheEnabled: Input.Optional[Boolean] = None,
    config: Input.Optional[besom.api.akamai.inputs.ProviderConfigArgs] = None,
    configSection: Input.Optional[String] = None,
    edgerc: Input.Optional[String] = None,
    requestLimit: Input.Optional[Int] = None
  )(using Context): ProviderArgs =
    new ProviderArgs(
      cacheEnabled = cacheEnabled.asOptionOutput(isSecret = false),
      config = config.asOptionOutput(isSecret = false),
      configSection = configSection.asOptionOutput(isSecret = false),
      edgerc = edgerc.asOptionOutput(isSecret = false),
      requestLimit = requestLimit.asOptionOutput(isSecret = false)
    )
