package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ClientlistListItemArgs private(
  description: Output[Option[String]],
  expirationDate: Output[Option[String]],
  tags: Output[Option[scala.collection.immutable.List[String]]],
  value: Output[String]
) derives Encoder, ArgsEncoder

object ClientlistListItemArgs:
  def apply(
    description: Input.Optional[String] = None,
    expirationDate: Input.Optional[String] = None,
    tags: Input.Optional[List[Input[String]]] = None,
    value: Input[String]
  )(using Context): ClientlistListItemArgs =
    new ClientlistListItemArgs(
      description = description.asOptionOutput(isSecret = false),
      expirationDate = expirationDate.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
