package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CloudletsApplicationLoadBalancerDataCenterArgs private(
  city: Output[Option[String]],
  cloudServerHostHeaderOverride: Output[Option[Boolean]],
  cloudService: Output[Option[Boolean]],
  continent: Output[String],
  country: Output[String],
  hostname: Output[Option[String]],
  latitude: Output[Double],
  livenessHosts: Output[Option[scala.collection.immutable.List[String]]],
  longitude: Output[Double],
  originId: Output[String],
  percent: Output[Double],
  stateOrProvince: Output[Option[String]]
) derives Encoder, ArgsEncoder

object CloudletsApplicationLoadBalancerDataCenterArgs:
  def apply(
    city: Input.Optional[String] = None,
    cloudServerHostHeaderOverride: Input.Optional[Boolean] = None,
    cloudService: Input.Optional[Boolean] = None,
    continent: Input[String],
    country: Input[String],
    hostname: Input.Optional[String] = None,
    latitude: Input[Double],
    livenessHosts: Input.Optional[List[Input[String]]] = None,
    longitude: Input[Double],
    originId: Input[String],
    percent: Input[Double],
    stateOrProvince: Input.Optional[String] = None
  )(using Context): CloudletsApplicationLoadBalancerDataCenterArgs =
    new CloudletsApplicationLoadBalancerDataCenterArgs(
      city = city.asOptionOutput(isSecret = false),
      cloudServerHostHeaderOverride = cloudServerHostHeaderOverride.asOptionOutput(isSecret = false),
      cloudService = cloudService.asOptionOutput(isSecret = false),
      continent = continent.asOutput(isSecret = false),
      country = country.asOutput(isSecret = false),
      hostname = hostname.asOptionOutput(isSecret = false),
      latitude = latitude.asOutput(isSecret = false),
      livenessHosts = livenessHosts.asOptionOutput(isSecret = false),
      longitude = longitude.asOutput(isSecret = false),
      originId = originId.asOutput(isSecret = false),
      percent = percent.asOutput(isSecret = false),
      stateOrProvince = stateOrProvince.asOptionOutput(isSecret = false)
    )
