package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CloudletsApplicationLoadBalancerLivenessSettingsArgs private(
  additionalHeaders: Output[Option[scala.Predef.Map[String, String]]],
  hostHeader: Output[Option[String]],
  interval: Output[Option[Int]],
  path: Output[String],
  peerCertificateVerification: Output[Option[Boolean]],
  port: Output[Int],
  protocol: Output[String],
  requestString: Output[Option[String]],
  responseString: Output[Option[String]],
  status3xxFailure: Output[Option[Boolean]],
  status4xxFailure: Output[Option[Boolean]],
  status5xxFailure: Output[Option[Boolean]],
  timeout: Output[Option[Double]]
) derives Encoder, ArgsEncoder

object CloudletsApplicationLoadBalancerLivenessSettingsArgs:
  def apply(
    additionalHeaders: Input.Optional[scala.Predef.Map[String, Input[String]]] = None,
    hostHeader: Input.Optional[String] = None,
    interval: Input.Optional[Int] = None,
    path: Input[String],
    peerCertificateVerification: Input.Optional[Boolean] = None,
    port: Input[Int],
    protocol: Input[String],
    requestString: Input.Optional[String] = None,
    responseString: Input.Optional[String] = None,
    status3xxFailure: Input.Optional[Boolean] = None,
    status4xxFailure: Input.Optional[Boolean] = None,
    status5xxFailure: Input.Optional[Boolean] = None,
    timeout: Input.Optional[Double] = None
  )(using Context): CloudletsApplicationLoadBalancerLivenessSettingsArgs =
    new CloudletsApplicationLoadBalancerLivenessSettingsArgs(
      additionalHeaders = additionalHeaders.asOptionOutput(isSecret = false),
      hostHeader = hostHeader.asOptionOutput(isSecret = false),
      interval = interval.asOptionOutput(isSecret = false),
      path = path.asOutput(isSecret = false),
      peerCertificateVerification = peerCertificateVerification.asOptionOutput(isSecret = false),
      port = port.asOutput(isSecret = false),
      protocol = protocol.asOutput(isSecret = false),
      requestString = requestString.asOptionOutput(isSecret = false),
      responseString = responseString.asOptionOutput(isSecret = false),
      status3xxFailure = status3xxFailure.asOptionOutput(isSecret = false),
      status4xxFailure = status4xxFailure.asOptionOutput(isSecret = false),
      status5xxFailure = status5xxFailure.asOptionOutput(isSecret = false),
      timeout = timeout.asOptionOutput(isSecret = false)
    )
