package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CloudwrapperActivationTimeoutsArgs private(
  create: Output[Option[String]],
  update: Output[Option[String]]
) derives Encoder, ArgsEncoder

object CloudwrapperActivationTimeoutsArgs:
  def apply(
    create: Input.Optional[String] = None,
    update: Input.Optional[String] = None
  )(using Context): CloudwrapperActivationTimeoutsArgs =
    new CloudwrapperActivationTimeoutsArgs(
      create = create.asOptionOutput(isSecret = false),
      update = update.asOptionOutput(isSecret = false)
    )
