package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CloudwrapperConfigurationLocationArgs private(
  capacity: Output[Option[besom.api.akamai.inputs.CloudwrapperConfigurationLocationCapacityArgs]],
  comments: Output[String],
  trafficTypeId: Output[Int]
) derives Encoder, ArgsEncoder

object CloudwrapperConfigurationLocationArgs:
  def apply(
    capacity: Input.Optional[besom.api.akamai.inputs.CloudwrapperConfigurationLocationCapacityArgs] = None,
    comments: Input[String],
    trafficTypeId: Input[Int]
  )(using Context): CloudwrapperConfigurationLocationArgs =
    new CloudwrapperConfigurationLocationArgs(
      capacity = capacity.asOptionOutput(isSecret = false),
      comments = comments.asOutput(isSecret = false),
      trafficTypeId = trafficTypeId.asOutput(isSecret = false)
    )
