package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CpsDvEnrollmentHttpChallengeArgs private(
  domain: Output[Option[String]],
  fullPath: Output[Option[String]],
  responseBody: Output[Option[String]]
) derives Encoder, ArgsEncoder

object CpsDvEnrollmentHttpChallengeArgs:
  def apply(
    domain: Input.Optional[String] = None,
    fullPath: Input.Optional[String] = None,
    responseBody: Input.Optional[String] = None
  )(using Context): CpsDvEnrollmentHttpChallengeArgs =
    new CpsDvEnrollmentHttpChallengeArgs(
      domain = domain.asOptionOutput(isSecret = false),
      fullPath = fullPath.asOptionOutput(isSecret = false),
      responseBody = responseBody.asOptionOutput(isSecret = false)
    )
