package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CpsDvEnrollmentNetworkConfigurationArgs private(
  clientMutualAuthentication: Output[Option[besom.api.akamai.inputs.CpsDvEnrollmentNetworkConfigurationClientMutualAuthenticationArgs]],
  cloneDnsNames: Output[Option[Boolean]],
  disallowedTlsVersions: Output[Option[scala.collection.immutable.List[String]]],
  geography: Output[String],
  mustHaveCiphers: Output[Option[String]],
  ocspStapling: Output[Option[String]],
  preferredCiphers: Output[Option[String]],
  quicEnabled: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object CpsDvEnrollmentNetworkConfigurationArgs:
  def apply(
    clientMutualAuthentication: Input.Optional[besom.api.akamai.inputs.CpsDvEnrollmentNetworkConfigurationClientMutualAuthenticationArgs] = None,
    cloneDnsNames: Input.Optional[Boolean] = None,
    disallowedTlsVersions: Input.Optional[List[Input[String]]] = None,
    geography: Input[String],
    mustHaveCiphers: Input.Optional[String] = None,
    ocspStapling: Input.Optional[String] = None,
    preferredCiphers: Input.Optional[String] = None,
    quicEnabled: Input.Optional[Boolean] = None
  )(using Context): CpsDvEnrollmentNetworkConfigurationArgs =
    new CpsDvEnrollmentNetworkConfigurationArgs(
      clientMutualAuthentication = clientMutualAuthentication.asOptionOutput(isSecret = false),
      cloneDnsNames = cloneDnsNames.asOptionOutput(isSecret = false),
      disallowedTlsVersions = disallowedTlsVersions.asOptionOutput(isSecret = false),
      geography = geography.asOutput(isSecret = false),
      mustHaveCiphers = mustHaveCiphers.asOptionOutput(isSecret = false),
      ocspStapling = ocspStapling.asOptionOutput(isSecret = false),
      preferredCiphers = preferredCiphers.asOptionOutput(isSecret = false),
      quicEnabled = quicEnabled.asOptionOutput(isSecret = false)
    )
