package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CpsDvEnrollmentNetworkConfigurationClientMutualAuthenticationArgs private(
  ocspEnabled: Output[Option[Boolean]],
  sendCaListToClient: Output[Option[Boolean]],
  setId: Output[Option[String]]
) derives Encoder, ArgsEncoder

object CpsDvEnrollmentNetworkConfigurationClientMutualAuthenticationArgs:
  def apply(
    ocspEnabled: Input.Optional[Boolean] = None,
    sendCaListToClient: Input.Optional[Boolean] = None,
    setId: Input.Optional[String] = None
  )(using Context): CpsDvEnrollmentNetworkConfigurationClientMutualAuthenticationArgs =
    new CpsDvEnrollmentNetworkConfigurationClientMutualAuthenticationArgs(
      ocspEnabled = ocspEnabled.asOptionOutput(isSecret = false),
      sendCaListToClient = sendCaListToClient.asOptionOutput(isSecret = false),
      setId = setId.asOptionOutput(isSecret = false)
    )
