package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CpsThirdPartyEnrollmentCsrArgs private(
  city: Output[String],
  countryCode: Output[String],
  organization: Output[String],
  organizationalUnit: Output[String],
  preferredTrustChain: Output[Option[String]],
  state: Output[String]
) derives Encoder, ArgsEncoder

object CpsThirdPartyEnrollmentCsrArgs:
  def apply(
    city: Input[String],
    countryCode: Input[String],
    organization: Input[String],
    organizationalUnit: Input[String],
    preferredTrustChain: Input.Optional[String] = None,
    state: Input[String]
  )(using Context): CpsThirdPartyEnrollmentCsrArgs =
    new CpsThirdPartyEnrollmentCsrArgs(
      city = city.asOutput(isSecret = false),
      countryCode = countryCode.asOutput(isSecret = false),
      organization = organization.asOutput(isSecret = false),
      organizationalUnit = organizationalUnit.asOutput(isSecret = false),
      preferredTrustChain = preferredTrustChain.asOptionOutput(isSecret = false),
      state = state.asOutput(isSecret = false)
    )
