package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthenticationArgs private(
  ocspEnabled: Output[Option[Boolean]],
  sendCaListToClient: Output[Option[Boolean]],
  setId: Output[Option[String]]
) derives Encoder, ArgsEncoder

object CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthenticationArgs:
  def apply(
    ocspEnabled: Input.Optional[Boolean] = None,
    sendCaListToClient: Input.Optional[Boolean] = None,
    setId: Input.Optional[String] = None
  )(using Context): CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthenticationArgs =
    new CpsThirdPartyEnrollmentNetworkConfigurationClientMutualAuthenticationArgs(
      ocspEnabled = ocspEnabled.asOptionOutput(isSecret = false),
      sendCaListToClient = sendCaListToClient.asOptionOutput(isSecret = false),
      setId = setId.asOptionOutput(isSecret = false)
    )
