package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamAzureConnectorArgs private(
  accessKey: Output[String],
  accountName: Output[String],
  compressLogs: Output[Option[Boolean]],
  containerName: Output[String],
  displayName: Output[String],
  path: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamAzureConnectorArgs:
  def apply(
    accessKey: Input[String],
    accountName: Input[String],
    compressLogs: Input.Optional[Boolean] = None,
    containerName: Input[String],
    displayName: Input[String],
    path: Input[String]
  )(using Context): DatastreamAzureConnectorArgs =
    new DatastreamAzureConnectorArgs(
      accessKey = accessKey.asOutput(isSecret = true),
      accountName = accountName.asOutput(isSecret = false),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      containerName = containerName.asOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      path = path.asOutput(isSecret = false)
    )
