package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamDatadogConnectorArgs private(
  authToken: Output[String],
  compressLogs: Output[Option[Boolean]],
  displayName: Output[String],
  endpoint: Output[String],
  service: Output[Option[String]],
  source: Output[Option[String]],
  tags: Output[Option[String]]
) derives Encoder, ArgsEncoder

object DatastreamDatadogConnectorArgs:
  def apply(
    authToken: Input[String],
    compressLogs: Input.Optional[Boolean] = None,
    displayName: Input[String],
    endpoint: Input[String],
    service: Input.Optional[String] = None,
    source: Input.Optional[String] = None,
    tags: Input.Optional[String] = None
  )(using Context): DatastreamDatadogConnectorArgs =
    new DatastreamDatadogConnectorArgs(
      authToken = authToken.asOutput(isSecret = true),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false),
      service = service.asOptionOutput(isSecret = false),
      source = source.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false)
    )
