package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamDeliveryConfigurationArgs private(
  fieldDelimiter: Output[Option[String]],
  format: Output[String],
  frequency: Output[besom.api.akamai.inputs.DatastreamDeliveryConfigurationFrequencyArgs],
  uploadFilePrefix: Output[Option[String]],
  uploadFileSuffix: Output[Option[String]]
) derives Encoder, ArgsEncoder

object DatastreamDeliveryConfigurationArgs:
  def apply(
    fieldDelimiter: Input.Optional[String] = None,
    format: Input[String],
    frequency: Input[besom.api.akamai.inputs.DatastreamDeliveryConfigurationFrequencyArgs],
    uploadFilePrefix: Input.Optional[String] = None,
    uploadFileSuffix: Input.Optional[String] = None
  )(using Context): DatastreamDeliveryConfigurationArgs =
    new DatastreamDeliveryConfigurationArgs(
      fieldDelimiter = fieldDelimiter.asOptionOutput(isSecret = false),
      format = format.asOutput(isSecret = false),
      frequency = frequency.asOutput(isSecret = false),
      uploadFilePrefix = uploadFilePrefix.asOptionOutput(isSecret = false),
      uploadFileSuffix = uploadFileSuffix.asOptionOutput(isSecret = false)
    )
