package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamDeliveryConfigurationFrequencyArgs private(
  intervalInSecs: Output[Int]
) derives Encoder, ArgsEncoder

object DatastreamDeliveryConfigurationFrequencyArgs:
  def apply(
    intervalInSecs: Input[Int]
  )(using Context): DatastreamDeliveryConfigurationFrequencyArgs =
    new DatastreamDeliveryConfigurationFrequencyArgs(
      intervalInSecs = intervalInSecs.asOutput(isSecret = false)
    )
