package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamElasticsearchConnectorArgs private(
  caCert: Output[Option[String]],
  clientCert: Output[Option[String]],
  clientKey: Output[Option[String]],
  contentType: Output[Option[String]],
  customHeaderName: Output[Option[String]],
  customHeaderValue: Output[Option[String]],
  displayName: Output[String],
  endpoint: Output[String],
  indexName: Output[String],
  mTls: Output[Option[Boolean]],
  password: Output[String],
  tlsHostname: Output[Option[String]],
  userName: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamElasticsearchConnectorArgs:
  def apply(
    caCert: Input.Optional[String] = None,
    clientCert: Input.Optional[String] = None,
    clientKey: Input.Optional[String] = None,
    contentType: Input.Optional[String] = None,
    customHeaderName: Input.Optional[String] = None,
    customHeaderValue: Input.Optional[String] = None,
    displayName: Input[String],
    endpoint: Input[String],
    indexName: Input[String],
    mTls: Input.Optional[Boolean] = None,
    password: Input[String],
    tlsHostname: Input.Optional[String] = None,
    userName: Input[String]
  )(using Context): DatastreamElasticsearchConnectorArgs =
    new DatastreamElasticsearchConnectorArgs(
      caCert = caCert.asOptionOutput(isSecret = true),
      clientCert = clientCert.asOptionOutput(isSecret = true),
      clientKey = clientKey.asOptionOutput(isSecret = true),
      contentType = contentType.asOptionOutput(isSecret = false),
      customHeaderName = customHeaderName.asOptionOutput(isSecret = false),
      customHeaderValue = customHeaderValue.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false),
      indexName = indexName.asOutput(isSecret = true),
      mTls = mTls.asOptionOutput(isSecret = false),
      password = password.asOutput(isSecret = true),
      tlsHostname = tlsHostname.asOptionOutput(isSecret = false),
      userName = userName.asOutput(isSecret = true)
    )
