package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamGcsConnectorArgs private(
  bucket: Output[String],
  compressLogs: Output[Option[Boolean]],
  displayName: Output[String],
  path: Output[Option[String]],
  privateKey: Output[String],
  projectId: Output[String],
  serviceAccountName: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamGcsConnectorArgs:
  def apply(
    bucket: Input[String],
    compressLogs: Input.Optional[Boolean] = None,
    displayName: Input[String],
    path: Input.Optional[String] = None,
    privateKey: Input[String],
    projectId: Input[String],
    serviceAccountName: Input[String]
  )(using Context): DatastreamGcsConnectorArgs =
    new DatastreamGcsConnectorArgs(
      bucket = bucket.asOutput(isSecret = false),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      path = path.asOptionOutput(isSecret = false),
      privateKey = privateKey.asOutput(isSecret = true),
      projectId = projectId.asOutput(isSecret = false),
      serviceAccountName = serviceAccountName.asOutput(isSecret = false)
    )
