package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamHttpsConnectorArgs private(
  authenticationType: Output[String],
  caCert: Output[Option[String]],
  clientCert: Output[Option[String]],
  clientKey: Output[Option[String]],
  compressLogs: Output[Option[Boolean]],
  contentType: Output[Option[String]],
  customHeaderName: Output[Option[String]],
  customHeaderValue: Output[Option[String]],
  displayName: Output[String],
  endpoint: Output[String],
  mTls: Output[Option[Boolean]],
  password: Output[Option[String]],
  tlsHostname: Output[Option[String]],
  userName: Output[Option[String]]
) derives Encoder, ArgsEncoder

object DatastreamHttpsConnectorArgs:
  def apply(
    authenticationType: Input[String],
    caCert: Input.Optional[String] = None,
    clientCert: Input.Optional[String] = None,
    clientKey: Input.Optional[String] = None,
    compressLogs: Input.Optional[Boolean] = None,
    contentType: Input.Optional[String] = None,
    customHeaderName: Input.Optional[String] = None,
    customHeaderValue: Input.Optional[String] = None,
    displayName: Input[String],
    endpoint: Input[String],
    mTls: Input.Optional[Boolean] = None,
    password: Input.Optional[String] = None,
    tlsHostname: Input.Optional[String] = None,
    userName: Input.Optional[String] = None
  )(using Context): DatastreamHttpsConnectorArgs =
    new DatastreamHttpsConnectorArgs(
      authenticationType = authenticationType.asOutput(isSecret = false),
      caCert = caCert.asOptionOutput(isSecret = true),
      clientCert = clientCert.asOptionOutput(isSecret = true),
      clientKey = clientKey.asOptionOutput(isSecret = true),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      contentType = contentType.asOptionOutput(isSecret = false),
      customHeaderName = customHeaderName.asOptionOutput(isSecret = false),
      customHeaderValue = customHeaderValue.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false),
      mTls = mTls.asOptionOutput(isSecret = false),
      password = password.asOptionOutput(isSecret = true),
      tlsHostname = tlsHostname.asOptionOutput(isSecret = false),
      userName = userName.asOptionOutput(isSecret = true)
    )
