package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamLogglyConnectorArgs private(
  authToken: Output[String],
  contentType: Output[Option[String]],
  customHeaderName: Output[Option[String]],
  customHeaderValue: Output[Option[String]],
  displayName: Output[String],
  endpoint: Output[String],
  tags: Output[Option[String]]
) derives Encoder, ArgsEncoder

object DatastreamLogglyConnectorArgs:
  def apply(
    authToken: Input[String],
    contentType: Input.Optional[String] = None,
    customHeaderName: Input.Optional[String] = None,
    customHeaderValue: Input.Optional[String] = None,
    displayName: Input[String],
    endpoint: Input[String],
    tags: Input.Optional[String] = None
  )(using Context): DatastreamLogglyConnectorArgs =
    new DatastreamLogglyConnectorArgs(
      authToken = authToken.asOutput(isSecret = true),
      contentType = contentType.asOptionOutput(isSecret = false),
      customHeaderName = customHeaderName.asOptionOutput(isSecret = false),
      customHeaderValue = customHeaderValue.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false)
    )
