package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamNewRelicConnectorArgs private(
  authToken: Output[String],
  contentType: Output[Option[String]],
  customHeaderName: Output[Option[String]],
  customHeaderValue: Output[Option[String]],
  displayName: Output[String],
  endpoint: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamNewRelicConnectorArgs:
  def apply(
    authToken: Input[String],
    contentType: Input.Optional[String] = None,
    customHeaderName: Input.Optional[String] = None,
    customHeaderValue: Input.Optional[String] = None,
    displayName: Input[String],
    endpoint: Input[String]
  )(using Context): DatastreamNewRelicConnectorArgs =
    new DatastreamNewRelicConnectorArgs(
      authToken = authToken.asOutput(isSecret = true),
      contentType = contentType.asOptionOutput(isSecret = false),
      customHeaderName = customHeaderName.asOptionOutput(isSecret = false),
      customHeaderValue = customHeaderValue.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false)
    )
