package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamOracleConnectorArgs private(
  accessKey: Output[String],
  bucket: Output[String],
  compressLogs: Output[Option[Boolean]],
  displayName: Output[String],
  namespace: Output[String],
  path: Output[String],
  region: Output[String],
  secretAccessKey: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamOracleConnectorArgs:
  def apply(
    accessKey: Input[String],
    bucket: Input[String],
    compressLogs: Input.Optional[Boolean] = None,
    displayName: Input[String],
    namespace: Input[String],
    path: Input[String],
    region: Input[String],
    secretAccessKey: Input[String]
  )(using Context): DatastreamOracleConnectorArgs =
    new DatastreamOracleConnectorArgs(
      accessKey = accessKey.asOutput(isSecret = true),
      bucket = bucket.asOutput(isSecret = false),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      namespace = namespace.asOutput(isSecret = false),
      path = path.asOutput(isSecret = false),
      region = region.asOutput(isSecret = false),
      secretAccessKey = secretAccessKey.asOutput(isSecret = true)
    )
