package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamS3ConnectorArgs private(
  accessKey: Output[String],
  bucket: Output[String],
  compressLogs: Output[Option[Boolean]],
  displayName: Output[String],
  path: Output[String],
  region: Output[String],
  secretAccessKey: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamS3ConnectorArgs:
  def apply(
    accessKey: Input[String],
    bucket: Input[String],
    compressLogs: Input.Optional[Boolean] = None,
    displayName: Input[String],
    path: Input[String],
    region: Input[String],
    secretAccessKey: Input[String]
  )(using Context): DatastreamS3ConnectorArgs =
    new DatastreamS3ConnectorArgs(
      accessKey = accessKey.asOutput(isSecret = true),
      bucket = bucket.asOutput(isSecret = false),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      path = path.asOutput(isSecret = false),
      region = region.asOutput(isSecret = false),
      secretAccessKey = secretAccessKey.asOutput(isSecret = true)
    )
