package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamSplunkConnectorArgs private(
  caCert: Output[Option[String]],
  clientCert: Output[Option[String]],
  clientKey: Output[Option[String]],
  compressLogs: Output[Option[Boolean]],
  customHeaderName: Output[Option[String]],
  customHeaderValue: Output[Option[String]],
  displayName: Output[String],
  endpoint: Output[String],
  eventCollectorToken: Output[String],
  mTls: Output[Option[Boolean]],
  tlsHostname: Output[Option[String]]
) derives Encoder, ArgsEncoder

object DatastreamSplunkConnectorArgs:
  def apply(
    caCert: Input.Optional[String] = None,
    clientCert: Input.Optional[String] = None,
    clientKey: Input.Optional[String] = None,
    compressLogs: Input.Optional[Boolean] = None,
    customHeaderName: Input.Optional[String] = None,
    customHeaderValue: Input.Optional[String] = None,
    displayName: Input[String],
    endpoint: Input[String],
    eventCollectorToken: Input[String],
    mTls: Input.Optional[Boolean] = None,
    tlsHostname: Input.Optional[String] = None
  )(using Context): DatastreamSplunkConnectorArgs =
    new DatastreamSplunkConnectorArgs(
      caCert = caCert.asOptionOutput(isSecret = true),
      clientCert = clientCert.asOptionOutput(isSecret = true),
      clientKey = clientKey.asOptionOutput(isSecret = true),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      customHeaderName = customHeaderName.asOptionOutput(isSecret = false),
      customHeaderValue = customHeaderValue.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false),
      eventCollectorToken = eventCollectorToken.asOutput(isSecret = true),
      mTls = mTls.asOptionOutput(isSecret = false),
      tlsHostname = tlsHostname.asOptionOutput(isSecret = false)
    )
