package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DatastreamSumologicConnectorArgs private(
  collectorCode: Output[String],
  compressLogs: Output[Option[Boolean]],
  contentType: Output[Option[String]],
  customHeaderName: Output[Option[String]],
  customHeaderValue: Output[Option[String]],
  displayName: Output[String],
  endpoint: Output[String]
) derives Encoder, ArgsEncoder

object DatastreamSumologicConnectorArgs:
  def apply(
    collectorCode: Input[String],
    compressLogs: Input.Optional[Boolean] = None,
    contentType: Input.Optional[String] = None,
    customHeaderName: Input.Optional[String] = None,
    customHeaderValue: Input.Optional[String] = None,
    displayName: Input[String],
    endpoint: Input[String]
  )(using Context): DatastreamSumologicConnectorArgs =
    new DatastreamSumologicConnectorArgs(
      collectorCode = collectorCode.asOutput(isSecret = true),
      compressLogs = compressLogs.asOptionOutput(isSecret = false),
      contentType = contentType.asOptionOutput(isSecret = false),
      customHeaderName = customHeaderName.asOptionOutput(isSecret = false),
      customHeaderValue = customHeaderValue.asOptionOutput(isSecret = false),
      displayName = displayName.asOutput(isSecret = false),
      endpoint = endpoint.asOutput(isSecret = false)
    )
