package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class DnsZoneTsigKeyArgs private(
  algorithm: Output[String],
  name: Output[String],
  secret: Output[String]
) derives Encoder, ArgsEncoder

object DnsZoneTsigKeyArgs:
  def apply(
    algorithm: Input[String],
    name: Input[String],
    secret: Input[String]
  )(using Context): DnsZoneTsigKeyArgs =
    new DnsZoneTsigKeyArgs(
      algorithm = algorithm.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      secret = secret.asOutput(isSecret = false)
    )
