package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class EdgeKvInitialDataArgs private(
  group: Output[Option[String]],
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object EdgeKvInitialDataArgs:
  def apply(
    group: Input.Optional[String] = None,
    key: Input[String],
    value: Input[String]
  )(using Context): EdgeKvInitialDataArgs =
    new EdgeKvInitialDataArgs(
      group = group.asOptionOutput(isSecret = false),
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
