package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentAdminContactArgs private(
  addressLineOne: Output[String],
  addressLineTwo: Output[Option[String]],
  city: Output[String],
  countryCode: Output[String],
  email: Output[String],
  firstName: Output[String],
  lastName: Output[String],
  organization: Output[String],
  phone: Output[String],
  postalCode: Output[String],
  region: Output[String],
  title: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentAdminContactArgs:
  def apply(
    addressLineOne: Input[String],
    addressLineTwo: Input.Optional[String] = None,
    city: Input[String],
    countryCode: Input[String],
    email: Input[String],
    firstName: Input[String],
    lastName: Input[String],
    organization: Input[String],
    phone: Input[String],
    postalCode: Input[String],
    region: Input[String],
    title: Input.Optional[String] = None
  )(using Context): GetCPSEnrollmentAdminContactArgs =
    new GetCPSEnrollmentAdminContactArgs(
      addressLineOne = addressLineOne.asOutput(isSecret = false),
      addressLineTwo = addressLineTwo.asOptionOutput(isSecret = false),
      city = city.asOutput(isSecret = false),
      countryCode = countryCode.asOutput(isSecret = false),
      email = email.asOutput(isSecret = false),
      firstName = firstName.asOutput(isSecret = false),
      lastName = lastName.asOutput(isSecret = false),
      organization = organization.asOutput(isSecret = false),
      phone = phone.asOutput(isSecret = false),
      postalCode = postalCode.asOutput(isSecret = false),
      region = region.asOutput(isSecret = false),
      title = title.asOptionOutput(isSecret = false)
    )
