package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentCsrArgs private(
  city: Output[String],
  countryCode: Output[String],
  organization: Output[String],
  organizationalUnit: Output[String],
  preferredTrustChain: Output[String],
  state: Output[String]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentCsrArgs:
  def apply(
    city: Input[String],
    countryCode: Input[String],
    organization: Input[String],
    organizationalUnit: Input[String],
    preferredTrustChain: Input[String],
    state: Input[String]
  )(using Context): GetCPSEnrollmentCsrArgs =
    new GetCPSEnrollmentCsrArgs(
      city = city.asOutput(isSecret = false),
      countryCode = countryCode.asOutput(isSecret = false),
      organization = organization.asOutput(isSecret = false),
      organizationalUnit = organizationalUnit.asOutput(isSecret = false),
      preferredTrustChain = preferredTrustChain.asOutput(isSecret = false),
      state = state.asOutput(isSecret = false)
    )
