package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentHttpChallengeArgs private(
  domain: Output[String],
  fullPath: Output[String],
  responseBody: Output[String]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentHttpChallengeArgs:
  def apply(
    domain: Input[String],
    fullPath: Input[String],
    responseBody: Input[String]
  )(using Context): GetCPSEnrollmentHttpChallengeArgs =
    new GetCPSEnrollmentHttpChallengeArgs(
      domain = domain.asOutput(isSecret = false),
      fullPath = fullPath.asOutput(isSecret = false),
      responseBody = responseBody.asOutput(isSecret = false)
    )
