package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentNetworkConfigurationArgs private(
  clientMutualAuthentications: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCPSEnrollmentNetworkConfigurationClientMutualAuthenticationArgs]],
  cloneDnsNames: Output[Boolean],
  disallowedTlsVersions: Output[scala.collection.immutable.List[String]],
  geography: Output[String],
  mustHaveCiphers: Output[String],
  ocspStapling: Output[String],
  preferredCiphers: Output[String],
  quicEnabled: Output[Boolean]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentNetworkConfigurationArgs:
  def apply(
    clientMutualAuthentications: Input[List[Input[besom.api.akamai.inputs.GetCPSEnrollmentNetworkConfigurationClientMutualAuthenticationArgs]]],
    cloneDnsNames: Input[Boolean],
    disallowedTlsVersions: Input[List[Input[String]]],
    geography: Input[String],
    mustHaveCiphers: Input[String],
    ocspStapling: Input[String],
    preferredCiphers: Input[String],
    quicEnabled: Input[Boolean]
  )(using Context): GetCPSEnrollmentNetworkConfigurationArgs =
    new GetCPSEnrollmentNetworkConfigurationArgs(
      clientMutualAuthentications = clientMutualAuthentications.asOutput(isSecret = false),
      cloneDnsNames = cloneDnsNames.asOutput(isSecret = false),
      disallowedTlsVersions = disallowedTlsVersions.asOutput(isSecret = false),
      geography = geography.asOutput(isSecret = false),
      mustHaveCiphers = mustHaveCiphers.asOutput(isSecret = false),
      ocspStapling = ocspStapling.asOutput(isSecret = false),
      preferredCiphers = preferredCiphers.asOutput(isSecret = false),
      quicEnabled = quicEnabled.asOutput(isSecret = false)
    )
