package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentNetworkConfigurationClientMutualAuthenticationArgs private(
  ocspEnabled: Output[Boolean],
  sendCaListToClient: Output[Boolean],
  setId: Output[String]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentNetworkConfigurationClientMutualAuthenticationArgs:
  def apply(
    ocspEnabled: Input[Boolean],
    sendCaListToClient: Input[Boolean],
    setId: Input[String]
  )(using Context): GetCPSEnrollmentNetworkConfigurationClientMutualAuthenticationArgs =
    new GetCPSEnrollmentNetworkConfigurationClientMutualAuthenticationArgs(
      ocspEnabled = ocspEnabled.asOutput(isSecret = false),
      sendCaListToClient = sendCaListToClient.asOutput(isSecret = false),
      setId = setId.asOutput(isSecret = false)
    )
