package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentsEnrollmentArgs private(
  adminContacts: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentAdminContactArgs]],
  certificateChainType: Output[String],
  certificateType: Output[String],
  commonName: Output[String],
  csrs: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentCsrArgs]],
  enableMultiStackedCertificates: Output[Boolean],
  enrollmentId: Output[Int],
  networkConfigurations: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentNetworkConfigurationArgs]],
  organizations: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentOrganizationArgs]],
  pendingChanges: Output[Boolean],
  registrationAuthority: Output[String],
  sans: Output[scala.collection.immutable.List[String]],
  secureNetwork: Output[String],
  signatureAlgorithm: Output[String],
  sniOnly: Output[Boolean],
  techContacts: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentTechContactArgs]],
  validationType: Output[String]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentsEnrollmentArgs:
  def apply(
    adminContacts: Input[List[Input[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentAdminContactArgs]]],
    certificateChainType: Input[String],
    certificateType: Input[String],
    commonName: Input[String],
    csrs: Input[List[Input[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentCsrArgs]]],
    enableMultiStackedCertificates: Input[Boolean],
    enrollmentId: Input[Int],
    networkConfigurations: Input[List[Input[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentNetworkConfigurationArgs]]],
    organizations: Input[List[Input[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentOrganizationArgs]]],
    pendingChanges: Input[Boolean],
    registrationAuthority: Input[String],
    sans: Input[List[Input[String]]],
    secureNetwork: Input[String],
    signatureAlgorithm: Input[String],
    sniOnly: Input[Boolean],
    techContacts: Input[List[Input[besom.api.akamai.inputs.GetCPSEnrollmentsEnrollmentTechContactArgs]]],
    validationType: Input[String]
  )(using Context): GetCPSEnrollmentsEnrollmentArgs =
    new GetCPSEnrollmentsEnrollmentArgs(
      adminContacts = adminContacts.asOutput(isSecret = false),
      certificateChainType = certificateChainType.asOutput(isSecret = false),
      certificateType = certificateType.asOutput(isSecret = false),
      commonName = commonName.asOutput(isSecret = false),
      csrs = csrs.asOutput(isSecret = false),
      enableMultiStackedCertificates = enableMultiStackedCertificates.asOutput(isSecret = false),
      enrollmentId = enrollmentId.asOutput(isSecret = false),
      networkConfigurations = networkConfigurations.asOutput(isSecret = false),
      organizations = organizations.asOutput(isSecret = false),
      pendingChanges = pendingChanges.asOutput(isSecret = false),
      registrationAuthority = registrationAuthority.asOutput(isSecret = false),
      sans = sans.asOutput(isSecret = false),
      secureNetwork = secureNetwork.asOutput(isSecret = false),
      signatureAlgorithm = signatureAlgorithm.asOutput(isSecret = false),
      sniOnly = sniOnly.asOutput(isSecret = false),
      techContacts = techContacts.asOutput(isSecret = false),
      validationType = validationType.asOutput(isSecret = false)
    )
