package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCPSEnrollmentsEnrollmentOrganizationArgs private(
  addressLineOne: Output[String],
  addressLineTwo: Output[String],
  city: Output[String],
  countryCode: Output[String],
  name: Output[String],
  phone: Output[String],
  postalCode: Output[String],
  region: Output[String]
) derives Encoder, ArgsEncoder

object GetCPSEnrollmentsEnrollmentOrganizationArgs:
  def apply(
    addressLineOne: Input[String],
    addressLineTwo: Input[String],
    city: Input[String],
    countryCode: Input[String],
    name: Input[String],
    phone: Input[String],
    postalCode: Input[String],
    region: Input[String]
  )(using Context): GetCPSEnrollmentsEnrollmentOrganizationArgs =
    new GetCPSEnrollmentsEnrollmentOrganizationArgs(
      addressLineOne = addressLineOne.asOutput(isSecret = false),
      addressLineTwo = addressLineTwo.asOutput(isSecret = false),
      city = city.asOutput(isSecret = false),
      countryCode = countryCode.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      phone = phone.asOutput(isSecret = false),
      postalCode = postalCode.asOutput(isSecret = false),
      region = region.asOutput(isSecret = false)
    )
