package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetClientlistListsListArgs private(
  createDate: Output[String],
  createdBy: Output[String],
  deprecated: Output[Boolean],
  itemsCount: Output[Int],
  listId: Output[String],
  listType: Output[String],
  name: Output[Option[String]],
  notes: Output[String],
  productionActivationStatus: Output[String],
  readOnly: Output[Boolean],
  shared: Output[Boolean],
  stagingActivationStatus: Output[String],
  tags: Output[scala.collection.immutable.List[String]],
  `type`: Output[Option[String]],
  updateDate: Output[String],
  updatedBy: Output[String],
  version: Output[Int]
) derives Encoder, ArgsEncoder

object GetClientlistListsListArgs:
  def apply(
    createDate: Input[String],
    createdBy: Input[String],
    deprecated: Input[Boolean],
    itemsCount: Input[Int],
    listId: Input[String],
    listType: Input[String],
    name: Input.Optional[String] = None,
    notes: Input[String],
    productionActivationStatus: Input[String],
    readOnly: Input[Boolean],
    shared: Input[Boolean],
    stagingActivationStatus: Input[String],
    tags: Input[List[Input[String]]],
    `type`: Input.Optional[String] = None,
    updateDate: Input[String],
    updatedBy: Input[String],
    version: Input[Int]
  )(using Context): GetClientlistListsListArgs =
    new GetClientlistListsListArgs(
      createDate = createDate.asOutput(isSecret = false),
      createdBy = createdBy.asOutput(isSecret = false),
      deprecated = deprecated.asOutput(isSecret = false),
      itemsCount = itemsCount.asOutput(isSecret = false),
      listId = listId.asOutput(isSecret = false),
      listType = listType.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      notes = notes.asOutput(isSecret = false),
      productionActivationStatus = productionActivationStatus.asOutput(isSecret = false),
      readOnly = readOnly.asOutput(isSecret = false),
      shared = shared.asOutput(isSecret = false),
      stagingActivationStatus = stagingActivationStatus.asOutput(isSecret = false),
      tags = tags.asOutput(isSecret = false),
      `type` = `type`.asOptionOutput(isSecret = false),
      updateDate = updateDate.asOutput(isSecret = false),
      updatedBy = updatedBy.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
