package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsApplicationLoadBalancerDataCenterArgs private(
  city: Output[String],
  cloudServerHostHeaderOverride: Output[Boolean],
  cloudService: Output[Boolean],
  continent: Output[String],
  country: Output[String],
  hostname: Output[String],
  latitude: Output[Double],
  livenessHosts: Output[scala.collection.immutable.List[String]],
  longitude: Output[Double],
  originId: Output[String],
  percent: Output[Double],
  stateOrProvince: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudletsApplicationLoadBalancerDataCenterArgs:
  def apply(
    city: Input[String],
    cloudServerHostHeaderOverride: Input[Boolean],
    cloudService: Input[Boolean],
    continent: Input[String],
    country: Input[String],
    hostname: Input[String],
    latitude: Input[Double],
    livenessHosts: Input[List[Input[String]]],
    longitude: Input[Double],
    originId: Input[String],
    percent: Input[Double],
    stateOrProvince: Input[String]
  )(using Context): GetCloudletsApplicationLoadBalancerDataCenterArgs =
    new GetCloudletsApplicationLoadBalancerDataCenterArgs(
      city = city.asOutput(isSecret = false),
      cloudServerHostHeaderOverride = cloudServerHostHeaderOverride.asOutput(isSecret = false),
      cloudService = cloudService.asOutput(isSecret = false),
      continent = continent.asOutput(isSecret = false),
      country = country.asOutput(isSecret = false),
      hostname = hostname.asOutput(isSecret = false),
      latitude = latitude.asOutput(isSecret = false),
      livenessHosts = livenessHosts.asOutput(isSecret = false),
      longitude = longitude.asOutput(isSecret = false),
      originId = originId.asOutput(isSecret = false),
      percent = percent.asOutput(isSecret = false),
      stateOrProvince = stateOrProvince.asOutput(isSecret = false)
    )
