package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsApplicationLoadBalancerLivenessSettingArgs private(
  additionalHeaders: Output[scala.Predef.Map[String, String]],
  hostHeader: Output[String],
  interval: Output[Int],
  path: Output[String],
  peerCertificateVerification: Output[Boolean],
  port: Output[Int],
  protocol: Output[String],
  requestString: Output[String],
  responseString: Output[String],
  status3xxFailure: Output[Boolean],
  status4xxFailure: Output[Boolean],
  status5xxFailure: Output[Boolean],
  timeout: Output[Double]
) derives Encoder, ArgsEncoder

object GetCloudletsApplicationLoadBalancerLivenessSettingArgs:
  def apply(
    additionalHeaders: Input[scala.Predef.Map[String, Input[String]]],
    hostHeader: Input[String],
    interval: Input[Int],
    path: Input[String],
    peerCertificateVerification: Input[Boolean],
    port: Input[Int],
    protocol: Input[String],
    requestString: Input[String],
    responseString: Input[String],
    status3xxFailure: Input[Boolean],
    status4xxFailure: Input[Boolean],
    status5xxFailure: Input[Boolean],
    timeout: Input[Double]
  )(using Context): GetCloudletsApplicationLoadBalancerLivenessSettingArgs =
    new GetCloudletsApplicationLoadBalancerLivenessSettingArgs(
      additionalHeaders = additionalHeaders.asOutput(isSecret = false),
      hostHeader = hostHeader.asOutput(isSecret = false),
      interval = interval.asOutput(isSecret = false),
      path = path.asOutput(isSecret = false),
      peerCertificateVerification = peerCertificateVerification.asOutput(isSecret = false),
      port = port.asOutput(isSecret = false),
      protocol = protocol.asOutput(isSecret = false),
      requestString = requestString.asOutput(isSecret = false),
      responseString = responseString.asOutput(isSecret = false),
      status3xxFailure = status3xxFailure.asOutput(isSecret = false),
      status4xxFailure = status4xxFailure.asOutput(isSecret = false),
      status5xxFailure = status5xxFailure.asOutput(isSecret = false),
      timeout = timeout.asOutput(isSecret = false)
    )
