package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsAudienceSegmentationMatchRuleMatchRuleForwardSettingsArgs private(
  originId: Output[Option[String]],
  pathAndQs: Output[Option[String]],
  useIncomingQueryString: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetCloudletsAudienceSegmentationMatchRuleMatchRuleForwardSettingsArgs:
  def apply(
    originId: Input.Optional[String] = None,
    pathAndQs: Input.Optional[String] = None,
    useIncomingQueryString: Input.Optional[Boolean] = None
  )(using Context): GetCloudletsAudienceSegmentationMatchRuleMatchRuleForwardSettingsArgs =
    new GetCloudletsAudienceSegmentationMatchRuleMatchRuleForwardSettingsArgs(
      originId = originId.asOptionOutput(isSecret = false),
      pathAndQs = pathAndQs.asOptionOutput(isSecret = false),
      useIncomingQueryString = useIncomingQueryString.asOptionOutput(isSecret = false)
    )
