package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsEdgeRedirectorMatchRuleMatchRuleArgs private(
  disabled: Output[Option[Boolean]],
  end: Output[Option[Int]],
  matchUrl: Output[Option[String]],
  matches: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudletsEdgeRedirectorMatchRuleMatchRuleMatchArgs]]],
  name: Output[Option[String]],
  redirectUrl: Output[String],
  start: Output[Option[Int]],
  statusCode: Output[Int],
  `type`: Output[String],
  useIncomingQueryString: Output[Option[Boolean]],
  useRelativeUrl: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetCloudletsEdgeRedirectorMatchRuleMatchRuleArgs:
  def apply(
    disabled: Input.Optional[Boolean] = None,
    end: Input.Optional[Int] = None,
    matchUrl: Input.Optional[String] = None,
    matches: Input.Optional[List[Input[besom.api.akamai.inputs.GetCloudletsEdgeRedirectorMatchRuleMatchRuleMatchArgs]]] = None,
    name: Input.Optional[String] = None,
    redirectUrl: Input[String],
    start: Input.Optional[Int] = None,
    statusCode: Input[Int],
    `type`: Input[String],
    useIncomingQueryString: Input.Optional[Boolean] = None,
    useRelativeUrl: Input.Optional[String] = None
  )(using Context): GetCloudletsEdgeRedirectorMatchRuleMatchRuleArgs =
    new GetCloudletsEdgeRedirectorMatchRuleMatchRuleArgs(
      disabled = disabled.asOptionOutput(isSecret = false),
      end = end.asOptionOutput(isSecret = false),
      matchUrl = matchUrl.asOptionOutput(isSecret = false),
      matches = matches.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      redirectUrl = redirectUrl.asOutput(isSecret = false),
      start = start.asOptionOutput(isSecret = false),
      statusCode = statusCode.asOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false),
      useIncomingQueryString = useIncomingQueryString.asOptionOutput(isSecret = false),
      useRelativeUrl = useRelativeUrl.asOptionOutput(isSecret = false)
    )
