package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsPhasedReleaseMatchRuleMatchRuleArgs private(
  disabled: Output[Option[Boolean]],
  end: Output[Option[Int]],
  forwardSettings: Output[besom.api.akamai.inputs.GetCloudletsPhasedReleaseMatchRuleMatchRuleForwardSettingsArgs],
  matchUrl: Output[Option[String]],
  matches: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudletsPhasedReleaseMatchRuleMatchRuleMatchArgs]]],
  matchesAlways: Output[Option[Boolean]],
  name: Output[Option[String]],
  start: Output[Option[Int]],
  `type`: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudletsPhasedReleaseMatchRuleMatchRuleArgs:
  def apply(
    disabled: Input.Optional[Boolean] = None,
    end: Input.Optional[Int] = None,
    forwardSettings: Input[besom.api.akamai.inputs.GetCloudletsPhasedReleaseMatchRuleMatchRuleForwardSettingsArgs],
    matchUrl: Input.Optional[String] = None,
    matches: Input.Optional[List[Input[besom.api.akamai.inputs.GetCloudletsPhasedReleaseMatchRuleMatchRuleMatchArgs]]] = None,
    matchesAlways: Input.Optional[Boolean] = None,
    name: Input.Optional[String] = None,
    start: Input.Optional[Int] = None,
    `type`: Input[String]
  )(using Context): GetCloudletsPhasedReleaseMatchRuleMatchRuleArgs =
    new GetCloudletsPhasedReleaseMatchRuleMatchRuleArgs(
      disabled = disabled.asOptionOutput(isSecret = false),
      end = end.asOptionOutput(isSecret = false),
      forwardSettings = forwardSettings.asOutput(isSecret = false),
      matchUrl = matchUrl.asOptionOutput(isSecret = false),
      matches = matches.asOptionOutput(isSecret = false),
      matchesAlways = matchesAlways.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      start = start.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
