package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsPhasedReleaseMatchRuleMatchRuleForwardSettingsArgs private(
  originId: Output[String],
  percent: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudletsPhasedReleaseMatchRuleMatchRuleForwardSettingsArgs:
  def apply(
    originId: Input[String],
    percent: Input[Int]
  )(using Context): GetCloudletsPhasedReleaseMatchRuleMatchRuleForwardSettingsArgs =
    new GetCloudletsPhasedReleaseMatchRuleMatchRuleForwardSettingsArgs(
      originId = originId.asOutput(isSecret = false),
      percent = percent.asOutput(isSecret = false)
    )
