package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsPolicyActivationArgs private(
  apiVersion: Output[String],
  network: Output[String],
  policyInfos: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudletsPolicyActivationPolicyInfoArgs]],
  propertyInfos: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudletsPolicyActivationPropertyInfoArgs]]
) derives Encoder, ArgsEncoder

object GetCloudletsPolicyActivationArgs:
  def apply(
    apiVersion: Input[String],
    network: Input[String],
    policyInfos: Input[List[Input[besom.api.akamai.inputs.GetCloudletsPolicyActivationPolicyInfoArgs]]],
    propertyInfos: Input[List[Input[besom.api.akamai.inputs.GetCloudletsPolicyActivationPropertyInfoArgs]]]
  )(using Context): GetCloudletsPolicyActivationArgs =
    new GetCloudletsPolicyActivationArgs(
      apiVersion = apiVersion.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false),
      policyInfos = policyInfos.asOutput(isSecret = false),
      propertyInfos = propertyInfos.asOutput(isSecret = false)
    )
